/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.WorldUtils;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class TeleportToPlayerMessage {
    String name;

    public TeleportToPlayerMessage(String name) {
        this.name = name;
    }

    public static void encode(TeleportToPlayerMessage data, FriendlyByteBuf buf) {
        buf.m_130070_(data.name);
    }

    public static TeleportToPlayerMessage decode(FriendlyByteBuf buf) {
        return new TeleportToPlayerMessage(buf.m_130136_(100));
    }

    public static void handle(TeleportToPlayerMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            if (!player.m_20310_(2)) {
                return;
            }
            Level ori = player.m_20193_();
            AtomicReference dest = new AtomicReference();
            AtomicReference otherPos = new AtomicReference();
            WorldUtils.applyToPlayer(data.name, player.f_8924_, o -> {
                dest.set(o.m_20193_());
                otherPos.set(o.m_142538_());
            });
            if (otherPos.get() == null) {
                player.m_6352_((Component)new TextComponent("Failed to load Player"), new UUID(0L, 0L));
            }
            WorldUtils.teleportPlayer((Player)player, ori, (Level)dest.get(), (BlockPos)otherPos.get());
        });
        ctx.get().setPacketHandled(true);
    }
}

